"use strict";
//
// Copyright 2020-2022 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const Constants_1 = require("../internal/Constants");
const Native = require("../../../Native");
const ExpiringProfileKeyCredential_1 = require("./ExpiringProfileKeyCredential");
const ProfileKeyCredentialPresentation_1 = require("./ProfileKeyCredentialPresentation");
const ProfileKeyCredentialRequestContext_1 = require("./ProfileKeyCredentialRequestContext");
class ClientZkProfileOperations {
    constructor(serverPublicParams) {
        this.serverPublicParams = serverPublicParams;
    }
    createProfileKeyCredentialRequestContext(userId, profileKey) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.createProfileKeyCredentialRequestContextWithRandom(random, userId, profileKey);
    }
    createProfileKeyCredentialRequestContextWithRandom(random, userId, profileKey) {
        return new ProfileKeyCredentialRequestContext_1.default(Native.ServerPublicParams_CreateProfileKeyCredentialRequestContextDeterministic(this.serverPublicParams.getContents(), random, userId.getServiceIdFixedWidthBinary(), profileKey.getContents()));
    }
    receiveExpiringProfileKeyCredential(profileKeyCredentialRequestContext, profileKeyCredentialResponse, now = new Date()) {
        return new ExpiringProfileKeyCredential_1.default(Native.ServerPublicParams_ReceiveExpiringProfileKeyCredential(this.serverPublicParams.getContents(), profileKeyCredentialRequestContext.getContents(), profileKeyCredentialResponse.getContents(), Math.floor(now.getTime() / 1000)));
    }
    createExpiringProfileKeyCredentialPresentation(groupSecretParams, profileKeyCredential) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.createExpiringProfileKeyCredentialPresentationWithRandom(random, groupSecretParams, profileKeyCredential);
    }
    createExpiringProfileKeyCredentialPresentationWithRandom(random, groupSecretParams, profileKeyCredential) {
        return new ProfileKeyCredentialPresentation_1.default(Native.ServerPublicParams_CreateExpiringProfileKeyCredentialPresentationDeterministic(this.serverPublicParams.getContents(), random, groupSecretParams.getContents(), profileKeyCredential.getContents()));
    }
}
exports.default = ClientZkProfileOperations;
//# sourceMappingURL=ClientZkProfileOperations.js.map